import logging, sys
from query import get_customers

# config logging to console
logging.basicConfig(
    stream=sys.stdout, 
    encoding='utf-8', 
    format='%(levelname)s:%(message)s',
    level=logging.DEBUG
)

# Get customers
try:
    customers = get_customers(limit=5, offset=5)
    for c in customers:
        print(f'{c["CustomerID"]} - {c["FirstName"]} {c["LastName"]}')
    
except Exception as e:
    logging.error(f"Error fetching customers: {e}")
        